/*
 * Decompiled with CFR 0.152.
 */
package org.springbyexample.bean.scope.thread;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class ThreadScopeAttributes {
    final Logger logger = LoggerFactory.getLogger(ThreadScopeAttributes.class);
    protected final Map<String, Object> hBeans = new HashMap<String, Object>();
    protected final Map<String, Runnable> hRequestDestructionCallbacks = new LinkedHashMap<String, Runnable>();

    protected final Map<String, Object> getBeanMap() {
        return this.hBeans;
    }

    protected final void registerRequestDestructionCallback(String name, Runnable callback) {
        Assert.notNull((Object)name, (String)"Name must not be null");
        Assert.notNull((Object)callback, (String)"Callback must not be null");
        this.hRequestDestructionCallbacks.put(name, callback);
    }

    protected final void clear() {
        this.processDestructionCallbacks();
        this.hBeans.clear();
    }

    private final void processDestructionCallbacks() {
        for (String name : this.hRequestDestructionCallbacks.keySet()) {
            Runnable callback = this.hRequestDestructionCallbacks.get(name);
            this.logger.debug("Performing destruction callback for '" + name + "' bean" + " on thread '" + Thread.currentThread().getName() + "'.");
            callback.run();
        }
        this.hRequestDestructionCallbacks.clear();
    }
}

