/*
 * Decompiled with CFR 0.152.
 */
package org.springbyexample.web.context;

import javax.servlet.ServletContext;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.config.Scope;
import org.springframework.util.StringUtils;
import org.springframework.web.context.ServletContextAware;

public class ServletContextScope
implements Scope,
ServletContextAware {
    protected ServletContext servletContext = null;
    protected String context = null;

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public String getContext() {
        return this.context;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public Object get(String name, ObjectFactory factory) {
        Object result = null;
        ServletContext sc = this.getServletContext();
        result = sc.getAttribute(name);
        if (result == null) {
            result = factory.getObject();
            sc.setAttribute(name, result);
        }
        return result;
    }

    public Object remove(String name) {
        Object result = null;
        ServletContext sc = this.getServletContext();
        result = sc.getAttribute(name);
        sc.removeAttribute(name);
        return result;
    }

    public void registerDestructionCallback(String name, Runnable callback) {
    }

    public String getConversationId() {
        return null;
    }

    protected ServletContext getServletContext() {
        ServletContext sc = null;
        if (StringUtils.hasText((String)this.context)) {
            sc = this.servletContext.getContext(this.context);
            if (sc == null) {
                throw new UnsupportedOperationException("Unable to get context for '" + this.context + "'.  " + "Server may not have cross context support or may be configured incorrectly.");
            }
        } else {
            sc = this.servletContext;
        }
        return sc;
    }
}

